<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'surname', 'email', 'password', 'status');

    public function products()
    {
        return $this->hasMany('Product', 'user_id');
    }

    public function commerce()
    {
        return $this->hasOne('Commerce', 'user_id');
    }

}